// koap.h
#ifndef KOAP_H
#define KOAP_H

#include <deque> // these get used everywhere

// koap directive types
#define INVALID 0
#define GLOBAL 1
#define INIT 2
#define CLALLOC 3
#define CLWRITE 4
#define CALL 5
#define CLREAD 6
#define CLFREE 7
#define CLCLEANUP 8
#define DEFINE 9 


// Functions defined in include.cpp:
extern string process_includes(string file);

// Functions defined in comments.cpp:
extern string rm_comments(string filename);

// Functions defined in kernels.cpp:
extern void strip_cl(string source, string &clsource, string &csource);
extern void get_kernelnames(string clsource, deque <string> &kernelnames);

// Functions defined in gen.cpp:
extern void initCONSTS(bool updateConsts, ifstream &fin);
extern deque <string> genKstrDecl();
extern deque <string> genGlobal(string prefix, deque <string> knames);
extern deque <string> genClCleanup(deque <string> knames);
extern deque <string> genClFree(string buf);
extern deque <string> genClRead(string buf);
extern deque <string> genClCall(deque <string> args);
extern deque <string> genClWrite(string buf);
extern deque <string> genClalloc(deque <string> args);
extern deque <string> genInit(string devType, deque <string> knames,
	string clcflags);

// Functions defined in util.cpp:
extern deque <string> dequeFromStr(string src);
extern string replace(string src, string pattern, string replacement);
extern string get_f_prefix(string filename);
extern void printStrDeque(ostream& out, deque <string>, string term);

// a package for dealing with parsed KOAP directives
typedef struct
{
	int type;
	deque <string> args;
} directive_t;

// also in util.cpp:
extern directive_t match(string);

#endif
